$crystal = 8000000

Config Portd.0 = Input
Config Portd.1 = Input
Config Portb = Output

'Variablen
Dim Color(3) As Byte
Dim Digit As Byte
Dim N As Byte
Dim _sec As Byte
Dim _min As Byte
Dim _hour As Byte
Dim Time_set As Bit
R Alias Color(_base) : G Alias Color(_base + 1) : B Alias Color(_base + 2)

'Neopixel LEDs sind an Port D.6 angeschlossen
Config Rainbow = 1 , Rb0_len = 12 , Rb0_port = Portd , Rb0_pin = 6
Rb_selectchannel 0

Portd.0 = 1
Portd.1 = 1
Time_set = 0

Config Timer1 = Counter , Edge = Rising , Noise Cancel = 1

On Timer1 Int_t1                                            'Bei berlauf Interruptprogramm aufrufen
Load Timer1 , 50                                            'Zhler laden

Enable Timer1

Enable Interrupts



Do

'Abfragen der Tasten
Debounce Pind.0 , 0 , Stunden , Sub
Debounce Pind.1 , 0 , Minuten , Sub

If Time_set = 1 Then                                        'Solange die Uhr nicht gestellt ist, alle LEDs auf Blau und die Nixies "00" anzeigen lassen.
   Gosub Anzeigen
Else
   Portb = 0
   R = &H00 : G = &H00 : B = &HFF
   For N = 0 To 11
      Rb_setcolor N , Color()
   Next N
   Rb_send
   Waitms 10
End If

Loop

Int_t1:                                                     'Dieses Interruptprogramm wird jede Sekunde durch Timer1 ausgelst
Load Timer1 , 50

Incr _sec

If _sec > 59 Then
_sec = 0
Incr _min
End If


If _min > 59 Then
_min = 0
Incr _hour
End If

If _hour > 11 Then
_hour = 0
End If

Return

Stunden:                                                    'Stellen der Stunden
Time_set = 1
Incr _hour
If _hour > 11 Then
_hour = 0
End If
Return

Minuten:                                                    'Stellen der Minuten
Time_set = 1
Incr _min
If _min > 59 Then
_min = 0
End If
_sec = 0
Return

Anzeigen:                                                   'Unterprogramm aktualisiert die Anzeige
For N = 0 To 11                                             'Neopixel LEDs einstellen
   If _hour = N Then
      R = &HFF : G = &H50 : B = &H00                        'Die Farbe fr die Stundenanzeige entspricht in etwa einer Glhbirne
      Rb_setcolor N , Color()
   Else
      R = &H00 : G = &H00 : B = &H00                        'Alle anderen LEDs abschalten
      Rb_setcolor N , Color()
   End If
Next N
Rb_send
Waitms 10

Digit = Makebcd(_min)                                       'Minuten in BCD Code umwandeln

'Um die Verdrahtung zu vereinfachen, wurden die 47141 Treiber ohne Rcksicht auf korrekte Belegung mit dem Mikrocontroller verbunden.
'Das wird nachfolgend korrigiert.

Portb.7 = Digit.0
Portb.5 = Digit.1
Portb.4 = Digit.2
Portb.6 = Digit.3

Portb.3 = Digit.4
Portb.1 = Digit.5
Portb.0 = Digit.6
Portb.2 = Digit.7

Return


End