$crystal = 4915200
$baud = 9600

Dim Cmd(10) As Byte
Dim Cmd_wert As Byte
Dim I As Byte

Dim Playlist(10) As Byte
Dim N As Integer
Dim Pulsdauer As Integer
Dim Ziffern As Byte
Dim Buchstaben As Byte
Dim Neue_zaehlung As Bit
Dim Blink_led As Byte
Dim Pointer As Byte
Dim Pointer_input As Byte
Dim Volume As Byte
Dim Titel As Byte
Dim Credit As Integer

Config Portd.4 = Input                                      'Puls
Config Portd.5 = Input                                      'Player bereit
Config Portd.6 = Output                                     'Diag LED

Config Portb.0 = Input                                      'Test
Config Portb.1 = Input                                      'Cancel

'Pull-UP
Portb.0 = 1
Portb.1 = 1
Portd.4 = 1

Config Debounce = 10

Port_led Alias Portd.6

Const Pause = 15

Declare Sub Cmd_reset
Declare Sub Set_checksum
Declare Sub Cmd_send
Declare Sub Set_ampgain(byval Pamp As Byte , Byval Pgain As Byte)
Declare Sub Set_volume(byval Pvalue As Byte)
Declare Sub Stop_file
Declare Sub Init_player
Declare Sub Play_frommp3(byval Pfile As Word)

Config Timer1 = Timer , Prescale = 1024
Stop Timer1
Timer1 = 0

Wait 3                                                      'Warten bis Player bereit ist

Call Init_player                                            'Initialisierung des Players

Waitms 1500

Call Set_volume(30)                                         'Lautstrke auf Maximum
Waitms 100

Call Set_ampgain(0 , 20)                                    'Verstrker abschalten
Waitms 100

Buchstaben = 0
Ziffern = 0

For I = 1 To 10                                             'Array leeren
   Playlist(i) = 0
Next I

Pointer_input = 1
Neue_zaehlung = 1
'Pusdauer_max = 30000                                        'Hoher Wert, um in Ziffern Schleife zu bleiben

Do
   Debounce Pinb.0 , 0 , Titel1 , Sub                       'Funktionstest des Player Moduls (spielt 0100.mp3 ab.)

   Debounce Pind.4 , 0 , Zaehlen , Sub

   Debounce Pinb.1 , 0 , Stop_play , Sub

   If Pind.5 = 1 Then                                       'Nur wenn der Player frei ist ausfhren!

   'Das Array Playliste absuchen und bei einem Wert > 0 das entsprechende Musikstck abspielen.
      Incr Pointer
      If Pointer > 10 Then
         Pointer = 1
      End If

      If Playlist(pointer) > 0 Then
         Titel = Playlist(pointer)
         Call Play_frommp3(titel)
         Waitms 100
         Playlist(pointer) = 0
      End If

   End If

   If Timer1 > 13000 Then                                   'Seit ~3 Sek. keine Impulse = Wahl beendet
      Stop Timer1
      Timer1 = 0
      Neue_zaehlung = 1
         If Pind.4 = 0 Then                                 'Wenn noch Kredit vorhanden ist, muss ein Impuls abgezogen werden
            Decr Buchstaben
         End If
      Gosub Auswerten
      Buchstaben = 0
      Ziffern = 0
   End If

   If Pind.4 = 0 Then                                       'Nicht zhlen, erster Impuls bedeutet "credit"
      Waitms 1
      Incr Credit
      If Credit > 1500 Then
         Credit = 1500
         Neue_zaehlung = 1
         Buchstaben = 0
         Ziffern = 0
         Stop Timer1
         Timer1 = 0
      End If
   End If
Loop


Zaehlen:
   Credit = 0
   If Neue_zaehlung = 1 Then                                'Zhlung neu beginnen?
      Neue_zaehlung = 0
      Start Timer1                                          'Timer1 misst die Dauer der Impulse
   End If

   If Timer1 > 800 Then                                     'Bei ~300ms GAP: Pause erkannt, ab jetzt Buchstaben zaehlen!
      Incr Buchstaben
      Port_led = 1                                          'GAP erkannt!
   Else
      Incr Ziffern
      Timer1 = 0
   End If

Return

'Die gezhlten Impulse in eine Titelnummer umrechnen und in das Array "Playlist" eintragen
Auswerten:
   Blink_led = 4
   Gosub Led_blinken
   Ziffern = 9 - Ziffern
   Ziffern = 20 * Ziffern
   Buchstaben = 21 - Buchstaben
   Titel = Ziffern + Buchstaben
   Incr Pointer_input
   If Pointer_input > 10 Then
      Pointer_input = 1
   End If
   Playlist(pointer_input) = Titel
   Buchstaben = 0
   Ziffern = 0
Return

'Diag LED blinken lassen
Led_blinken:
   For N = 1 To Blink_led
      Port_led = 1
      Waitms 100
      Port_led = 0
      Waitms 100
   Next N
Return

Stop_play:
   Call Stop_file
   Wait 1
Return

'Testprogramm fr Player
Titel1:
   Titel = 100
   Call Play_frommp3(titel)                                 '0100.mp3 abspielen ...
   Waitms 100
Return


'Die folgenden Routinen zur Steuerung des MP3 Players stammen von G-HEINRICHS.DE!

Sub Cmd_reset
   Cmd(1) = &H7E
   Cmd(2) = &HFF
   Cmd(3) = &H06
   Cmd(4) = 0
   Cmd(5) = 0
   Cmd(6) = 0
   Cmd(7) = 0
   Cmd(8) = 0
   Cmd(9) = 0
   Cmd(10) = &HEF
End Sub

Sub Set_checksum
   Local Checksum1 As Integer
   Checksum1 = 0
   For I = 2 To 7
      Cmd_wert = Cmd(i)
      Checksum1 = Checksum1 - Cmd_wert
   Next I
   Cmd(8) = High(checksum1)                                 'High-Byte
   Cmd(9) = Low(checksum1)                                  'Low-Byte
End Sub

Sub Cmd_send
   Call Set_checksum
   Printbin Cmd(1) ; 10
End Sub


Sub Set_volume(byval Pvalue As Byte)
   Call Cmd_reset
   Cmd(4) = &H06
   Cmd(7) = Pvalue                                          'High Byte = 0
   Call Cmd_send
   Waitms Pause
End Sub

'Function Init_player() As Byte
Function Init_player
   Call Cmd_reset
   Cmd(4) = &H0C
   Call Cmd_send
'   Call Cmd_get
'   Init_player = Cmd(7)
End Function

Sub Set_ampgain(byval Pamp As Byte , Byval Pgain As Byte)
   Call Cmd_reset
   Cmd(4) = &H10
   Cmd(6) = Pamp
   Cmd(7) = Pgain
   Call Cmd_send
   Waitms Pause
End Sub

Sub Play_frommp3(byval Pfile As Word)
   Call Cmd_reset
   Cmd(4) = &H12
   Cmd(6) = High(pfile)
   Cmd(7) = Low(pfile)
   Call Cmd_send
   Waitms Pause
End Sub

Sub Stop_file
   Call Cmd_reset
   Cmd(4) = &H16
   Call Cmd_send
   Waitms Pause
End Sub