$crystal = 8000000                                          '8MHz


Config Portc.1 = Output                                     'Servo
Config Portb.1 = Output                                     'Richtung Stepper
Config Portb.2 = Output                                     'Puls
Config Portb.3 = Output                                     'Enable Stepper

Config Portc.5 = Input                                      'Taste Kalibrierung

Config Portd = Input                                        'restliche Tasten

'Pull-Ups einschalten & Ports auf Default einstellen
Portd = 255

Portc.5 = 1

Portb.1 = 0
Portb.2 = 0
Portb.3 = 0

'Servo Anschluss definieren
Config Servos = 1 , Servo1 = Portc.1 , Reload = 10          ' , Interval = 100       ' , Timer = Timer1

Enable Interrupts

'Variablen definieren
Dim Fuellzeit As Integer
Dim Efuellzeit As Eram Integer
Dim Voll1 As Bit
Dim Voll2 As Bit
Dim Voll3 As Bit
Dim Voll4 As Bit
Dim Voll5 As Bit
Dim Schritte As Integer
Dim Schritte_fuellzeit As Integer
Dim Led As Byte
Dim Position As Byte
Dim Pos(5) As Byte
Dim Epos(5) As Eram Byte
Dim Color(3) As Byte
R Alias Color(_base) : G Alias Color(_base + 1) : B Alias Color(_base + 2)

'RGB LEDs definieren
Config Rainbow = 1 , Rb0_len = 5 , Rb0_port = Portc , Rb0_pin = 3

Rb_selectchannel 0



'Gespeicherte Parameter aus EEPROM holen
Fuellzeit = Efuellzeit
Pos(1) = Epos(1)
Pos(2) = Epos(2)
Pos(3) = Epos(3)
Pos(4) = Epos(4)
Pos(5) = Epos(5)

'for testing
'Fuellzeit = 5000                                            'Zeit in der die Pumpe luft bzw. Anzahl Steps!
'Pos(1) = 70
'Pos(2) = 90
'Pos(3) = 100
'Pos(4) = 120
'Pos(5) = 140

'Sollten beim Einschalten schon Glser stehen, nicht befllen (Alle Glser auf "voll" einstellen)!
Voll1 = 1
Voll2 = 1
Voll3 = 1
Voll4 = 1
Voll5 = 1

Servo(1) = Pos(1)                                           'Servo in Ausgangsstellung

Waitms 100                                                  'Warten bis alle Spannungen stabil sind

'Fr initiale Einrichtung beim ersten Start: Defaultwerte laden und in EEPROM schieben wenn Pin auf low.
If Pind.6 = 0 Then
R = 150 : G = 0 : B = 0                                     'LED Rot
Rb_setcolor 0 , Color()
Rb_send
Wait 1
Pos(1) = 70
Pos(2) = 90
Pos(3) = 100
Pos(4) = 120
Pos(5) = 140
Epos(1) = Pos(1)
Epos(2) = Pos(2)
Epos(3) = Pos(3)
Epos(4) = Pos(4)
Epos(5) = Pos(5)
Fuellzeit = 500
Efuellzeit = Fuellzeit

R = 0 : G = 150 : B = 0                                     'LED Grn
Rb_setcolor 0 , Color()
Rb_send
Waitms 10

Do
'Verlassen nur durch Abschalten
Loop

End If

'Kalibrierung starten
If Pinc.5 = 0 Then

   If Pind.0 = 0 Then                                       'Fllmenge kalibrieren wenn auf Pos1 ein Glas steht ansonsten Positionen kalibrieren
      Servo(1) = Pos(1)                                     'Servo auf Pos1 fahren
      Waitms 500
      R = 150 : G = 150 : B = 150                           'Licht an
      Rb_setcolor 0 , Color()
      Rb_send
      Waitms 10

      Do                                                    'Verlassen nur durch Abschalten

         If Pind.1 = 0 Then
            Fuellzeit = 0                                   'Zhler auf 0
            R = 150 : G = 0 : B = 0                         'LED auf Rot whrend Pumpe luft
            Rb_setcolor 0 , Color()
            Rb_send
            Waitms 10

            Portb.3 = 1
            While Pind.1 = 0                                'Fllen, solange Pind.1 auf 0 ist
               Portb.2 = 1
               Waitus 500
               Portb.2 = 0
               Waitus 500
               Incr Fuellzeit
            Wend
            Portb.3 = 0
            R = 150 : G = 150 : B = 150                     'Licht wieder wei
            Rb_setcolor 0 , Color()
            Rb_send
            Waitms 50                                       'entprellen
            Efuellzeit = Fuellzeit                          'speichern im eeprom
         End If

      Loop

   Else
      R = 0 : G = 0 : B = 150                               'LED an Pos 1 auf blau
      Rb_setcolor 0 , Color()
      Rb_send
      Waitms 10
      Position = 1
      Do                                                    'Verlassen nur durch Abschalten
         Debounce Pind.1 , 0 , Anfahren_pos , Sub           'Aufruf der den Tasten zugeordneten Unterprogramme

         Debounce Pind.2 , 0 , Inc_pos , Sub
         Debounce Pind.3 , 0 , Dec_pos , Sub

         Servo(1) = Pos(position)                           'Servo auf zu kalibrierende Position bewegen


      Loop

   End If
End If



'Hauptprogramm - Hauptschleife
Do

If Pind.0 = 0 Then                                          'Glas auf Pos.1?
   If Voll1 = 0 Then                                        'Nur aufrufen, wenn Glas nicht schon gefllt wurde
      Voll1 = 1
      R = 150 : G = 0 : B = 0                               'LED rot
      Rb_setcolor 0 , Color()
      Rb_send                                               'Daten an LEDs senden
      Waitms 10                                             'LEDs Zeit geben
      Servo(1) = Pos(1)                                     'Servo auf Position
      Gosub Fuellen                                         'Unterprogramm zur Ansteuerung der Pumpe aufrufen
      R = 150 : G = 150 : B = 150                           'LED wei, wenn Getrnk fertig
      Rb_setcolor 0 , Color()
      Rb_send
      Waitms 10
   End If
Else
   If Voll1 = 1 Then                                        'Glas wurde entnommen, Fllstatus ndern & Platz wieder freigeben
      Voll1 = 0
      R = 0 : G = 150 : B = 0                               'LED grn
      Rb_setcolor 0 , Color()
      Rb_send
      Waitms 10
   End If
End If

Waitms 100                                                  'Entprellen

If Pind.1 = 0 Then                                          'Glas auf Pos.2?
   If Voll2 = 0 Then
      Voll2 = 1
      R = 150 : G = 0 : B = 0
      Rb_setcolor 1 , Color()
      Rb_send
      Waitms 10
      Servo(1) = Pos(2)
      Gosub Fuellen
      R = 150 : G = 150 : B = 150
      Rb_setcolor 1 , Color()
      Rb_send
      Waitms 10
   End If
Else
   If Voll2 = 1 Then
      Voll2 = 0
      R = 0 : G = 150 : B = 0
      Rb_setcolor 1 , Color()
      Rb_send
      Waitms 10
   End If
End If

Waitms 100                                                  'Entprellen

If Pind.2 = 0 Then                                          'Glas auf Pos.3?
   If Voll3 = 0 Then
      Voll3 = 1
      R = 150 : G = 0 : B = 0
      Rb_setcolor 2 , Color()
      Rb_send
      Waitms 10
      Servo(1) = Pos(3)
      Gosub Fuellen
      R = 150 : G = 150 : B = 150
      Rb_setcolor 2 , Color()
      Rb_send
      Waitms 10
   End If
Else
   If Voll3 = 1 Then
      Voll3 = 0
      R = 0 : G = 150 : B = 0
      Rb_setcolor 2 , Color()
      Rb_send
      Waitms 10
   End If
End If

Waitms 100                                                  'Entprellen

If Pind.3 = 0 Then                                          'Glas auf Pos.4?
   If Voll4 = 0 Then
      Voll4 = 1
      R = 150 : G = 0 : B = 0
      Rb_setcolor 3 , Color()
      Rb_send
      Waitms 10
      Servo(1) = Pos(4)
      Gosub Fuellen
      R = 150 : G = 150 : B = 150
      Rb_setcolor 3 , Color()
      Rb_send
      Waitms 10
   End If
Else
   If Voll4 = 1 Then
      Voll4 = 0
      R = 0 : G = 150 : B = 0
      Rb_setcolor 3 , Color()
      Rb_send
      Waitms 10
   End If
End If

Waitms 100                                                  'Entprellen



Waitms 100                                                  'Entprellen

If Pind.4 = 0 Then                                          'Unterprogramm Befllen / reinigen
   Waitms 10
   Portb.3 = 1                                              'Treiber einschalten
   While Pind.4 = 0                                         'Pumpen, solange die Taste gehalten wird
      Portb.2 = 1
      Waitus 500
      Portb.2 = 0
      Waitus 500
   Wend
   Portb.3 = 0                                              'Treiber aus
End If

Waitms 100                                                  'Entprellen

Loop

'Unterprogramm "Fllen"
Fuellen:
Waitms 1000                                                 'Warten bis Servo auf Position steht

Portb.3 = 1                                                 'Treiber einschalten
Schritte_fuellzeit = Fuellzeit + 200
For Schritte = 1 To Schritte_fuellzeit                      'Die vorher festgelegte Anzahl von Schritten drehen & Pulse erzeugen ...
   Portb.2 = 1
   Waitus 500
   Portb.2 = 0
   Waitus 500
Next Schritte

Portb.3 = 0                                                 'Treiber abschalten

'Etwas zurckdrehen, um Nachtropfen zu unterbinden
Waitms 100                                                  'Kurz warten
Portb.1 = 1                                                 'Drehrichtung ndern
Portb.3 = 1                                                 'Treiber einschalten

For Schritte = 1 To 200                                     '200 Steps rckwrts
   Portb.2 = 1
   Waitus 500
   Portb.2 = 0
   Waitus 500
Next Schritte

Portb.3 = 0
Portb.1 = 0

Return

Anfahren_pos:
Incr Position                                               'Zhler auf nchste Position
If Position > 4 Then
Position = 1
End If

R = 0 : G = 0 : B = 0                                       'Speicher fr LEDs auf "0"
For Led = 0 To 3
Rb_setcolor Led , Color()
Next Led

Led = Position - 1                                          'LEDs zhlen ab 0

R = 0 : G = 0 : B = 150                                     'LED an neuer Pos. auf blau
Rb_setcolor Led , Color()
Rb_send                                                     'senden der Daten an die LEDs
Waitms 10

'neue Werte ins eeprom schreiben
Epos(1) = Pos(1)
Epos(2) = Pos(2)
Epos(3) = Pos(3)
Epos(4) = Pos(4)
Epos(5) = Pos(5)
Return

'Die folgenden Unterprogramme verndern die Kalibrierungswerte der Positionen
'Der virtuelle Anschlag kann durch ndern der Werte in den if-then Abfragen verndert werden.
'Achtung: den tatschlichen Drehwinkel beachten um den Servo nicht zu schdigen.
Inc_pos:
Incr Pos(position)
If Pos(position) > 250 Then
Pos(position) = 250
End If
Return

Dec_pos:
Decr Pos(position)
If Pos(position) < 10 Then
Pos(position) = 10
End If
Return